ORCA/M Asm65816 2.1.0

0001 B375                       EJECT 
0002 B375                       TITLE 'Functions and Subroutines'
0003 B375
0004 B375              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0005 B375              ;	by EdAsmCvtIIGS version 1.2d5 on 5/9/91 at 6:22:11 PM
0006 B375
0007 B375
0008 B375              * BASIC FUNCTION HOOK:
0009 B375              *
0010 B375              * INPUT: Y=FUNCTION AS FOLLOWS:
0011 B375              *
0012 B375              *           1 = KEYIN 
0013 B375              *           2 = Fix escape char 
0014 B375              *           3 = BASCALCC 
0015 B375              *           4 = VTABC or VTABCZ
0016 B375              *           5 = HOME
0017 B375              *           6 = SCROLL 
0018 B375              *           7 = CLREOL 
0019 B375              *           8 = CLREOLZ 
0020 B375              *           9 = RESET  
0021 B375              *           A = CLREOP 
0022 B375              *           B = RDKEY  
0023 B375              *           C = SETWND 
0024 B375              *           D = Fix pick for monitor
0025 B375              *           E = set 40 columns on PR#0/IN#0
0026 B375              *
0027 B375
0028 B375 A5 22        F_HOME   LDA   WNDTOP
0029 B377 85 25                 STA   CV
0030 B379 64 24                 STZ   CH                       ;Reset CH
0031 B37B A4 24        F_CLREOP LDY   CH                       ; ESC F IS CLR TO END OF PAGE
0032 B37D A5 25                 LDA   CV
0033 B37F 48           CLEOP1   PHA   
0034 B380 20 9C CD              JSR   VTABCZ
0035 B383 20 35 B4              JSR   X_CLREOLZ
0036 B386 A0 00                 LDY   #$00
0037 B388 68                    PLA   
0038 B389 1A                    INC   A                        ;ADC #$00 ;(carry set)
0039 B38A C5 23                 CMP   WNDBTM
0040 B38C 90 F1                 BCC   CLEOP1
0041 B38E B0 29                 BCS   GVTZ                     ;=>always to VTABCZ
0042 B390
0043 B390 A5 22        F_SCROLL LDA   WNDTOP
0044 B392 48                    PHA   
0045 B393 20 9C CD              JSR   VTABCZ
0046 B396 A5 28        SCRL1    LDA   BASL
0047 B398 85 2A                 STA   BAS2L
0048 B39A A5 29                 LDA   BASH
0049 B39C 85 2B                 STA   BAS2H
0050 B39E A4 21                 LDY   WNDWDTH
0051 B3A0 88                    DEY   
0052 B3A1 68                    PLA   
0053 B3A2 1A                    INC   A                        ;ADC #$01  
0054 B3A3 C5 23                 CMP   WNDBTM
0055 B3A5 B0 0D                 BCS   @2
0056 B3A7 48                    PHA   
0057 B3A8 20 9C CD              JSR   VTABCZ
0058 B3AB B1 28        @1       LDA   (BASL),Y
0059 B3AD 91 2A                 STA   (BAS2L),Y
0060 B3AF 88                    DEY   
0061 B3B0 10 F9                 BPL   @1
0062 B3B2 30 E2                 BMI   SCRL1
0063 B3B4 A0 00        @2       LDY   #$00
0064 B3B6 20 35 B4              JSR   X_CLREOLZ
0065 B3B9 A5 25        GVTZ     LDA   CV
0066 B3BB 4C 9C CD     GVTZ2    JMP   VTABCZ                   ;set vertical base
0067 B3BE
0068 B3BE              F_SETWND EQU   *
0069 B3BE A9 28                 LDA   #40
0070 B3C0 85 21                 STA   WNDWDTH
0071 B3C2 A9 18                 LDA   #24
0072 B3C4 85 23                 STA   WNDBTM
0073 B3C6 3A                    DEC   A                        ;LDA #23
0074 B3C7 85 25                 STA   CV
0075 B3C9 D0 F0                 BNE   GVTZ2                    ;=>go do vtab, exit
0076 B3CB
0077 B3CB              * Load Y from BAS2L and clear line
0078 B3CB
0079 B3CB A4 2A        F_CLREOLZ LDY   BAS2L                   ;set up by $F8 ROM
0080 B3CD 80 66                 BRA   X_CLREOLZ                ;JMP X_CLREOLZ ;and clear line
0081 B3CF
0082 B3CF              * 80 column routines begin here
0083 B3CF
0084 B3CF              * Clear to end of line using Y = BAS2L
0085 B3CF              * which was set up by the $F8 ROM
0086 B3CF
0087 B3CF A4 2A        B_CLREOLZ LDY   BAS2L                   ;get Y
0088 B3D1 4C 43 CC              JMP   X_GSEOLZ                 ;clear to end of line
0089 B3D4
0090 B3D4 20 37 CC     B_HOME   JSR   X_FF                     ;HOME & CLEAR
0091 B3D7 AD 7B 05              LDA   OURCH
0092 B3DA 85 24                 STA   CH                       ;COPY CH/CV FOR CALLER
0093 B3DC 8D 7B 04              STA   OLDCH                    ;REMEMBER WHAT WE SET
0094 B3DF 4C 97 CD              JMP   VTABC                    ;calc base & return
0095 B3E2
0096 B3E2              * Complete PR# or IN# call.  Quit video firmware
0097 B3E2              * if PR#0 and it was active (B_QUIT).  Complete call
0098 B3E2              * if inactive (F_QUIT).
0099 B3E2
0100 B3E2              B_QUIT   EQU   *
0101 B3E2 B4 00                 LDY   LOC0,X                   ;was it PR#0/IN#0?
0102 B3E4 F0 0F                 BEQ   NOT0                     ;=>no, not slot 0
0103 B3E6 C0 1B                 CPY   #KEYIN                   ;was it IN#0?
0104 B3E8 F0 0E                 BEQ   IS0                      ;=>yes, update high byte
0105 B3EA 20 19 CD              JSR   QUIT                     ;quit the firmware
0106 B3ED B4 00        F_QUIT   LDY   LOC0,X                   ;get low byte into Y
0107 B3EF F0 04                 BEQ   NOT0                     ;not slot 0, firmware inactive
0108 B3F1 A9 FD        F8HOOK   LDA   #>KEYIN                  ;set high byte to $FD
0109 B3F3 95 01                 STA   LOC1,X
0110 B3F5 B5 01        NOT0     LDA   LOC1,X                   ;restore accumulator
0111 B3F7 60                    RTS   
0112 B3F8
0113 B3F8 A5 37        IS0      LDA   CSWH                     ;is $C3 in output hook?
0114 B3FA C9 C3                 CMP   #>BASICIN
0115 B3FC D0 F3                 BNE   F8HOOK                   ;=>no, set to $FD0C
0116 B3FE 4C 32 C8              JMP   C3IN                     ;else set to $C305, exit A=$C3
0117 B401
0118 B401 A4 24        F_RDKEY  LDY   CH                       ;else do normal 40 cursor
0119 B403 B1 28                 LDA   (BASL),Y                 ;grab the character
0120 B405 48                    PHA   
0121 B406 29 3F                 AND   #$3F                     ;set screen to flash
0122 B408 09 40                 ORA   #$40
0123 B40A 91 28                 STA   (BASL),Y                 ;and display it
0124 B40C 68                    PLA   
0125 B40D 60                    RTS                            ;return (A=char) 
0126 B40E
0127 B40E A8           F_BASCALCCC TAY                         ;restore Y
0128 B40F A5 28                 LDA   BASL                     ;restore A
0129 B411 4C 64 CA              JMP   BASCALCC                 ;calculate base address
0130 B414
0131 B414              B_ESCFIX EQU   *
0132 B414 20 AD CD              JSR   UPSHFT                   ;upshift lowercase
0133 B417 DA                    PHX                            ;Must use X for this
0134 B418 A2 03                 LDX   #4-1                     ;SCAN FOR A MATCH
0135 B41A              @2       EQU   *
0136 B41A DF FA C3 FF           CMP   >ESCIN,X                 ;IS IT?
0137 B41E D0 04                 BNE   @1                       ;=>NAW
0138 B420 BF 29 B4 FF           LDA   >ESCOUT,X                ;YES, TRANSLATE IT
0139 B424              @1       EQU   *
0140 B424 CA                    DEX   
0141 B425 10 F3                 BPL   @2
0142 B427 FA                    PLX                            ;Restore 'X'
0143 B428 60                    RTS                            ;RETURN:CHAR IN AC 
0144 B429
0145 B429                                                      ; SEG $FF
0146 B429              ESCOUT   EQU   *
0147 B429                                                      ; SEG $00
0148 B429 CA CB CD C9           DC B:'JKMI'
0149 B42D
0150 B42D              * Pick an 80 column character for the monitor
0151 B42D
0152 B42D              FIXPICK  EQU   *                        ;get 80 column cursor
0153 B42D 20 B8 CD              JSR   PICKY                    ;pick the character 
0154 B430 09 80                 ORA   #$80                     ;always pick as normal
0155 B432 60                    RTS                            ;and return
0156 B433
0157 B433              * Load CH into Y and clear line
0158 B433
0159 B433              F_CLREOL EQU   *
0160 B433 A4 24                 LDY   CH                       ;get horizontal position
0161 B435 A9 A0        X_CLREOLZ LDA   #$A0                    ;store a normal blank
0162 B437 2C 1E C0              BIT   ALTCHARSET               ;unless alternate char set
0163 B43A 10 06                 BPL   @1
0164 B43C 24 32                 BIT   INVFLG                   ;and inverse
0165 B43E 30 02                 BMI   @1
0166 B440 A9 20                 LDA   #$20                     ;use inverse blank
0167 B442 4C 4E CC     @1       JMP   CLR40                    ;clear to end of line
0168 B445
0169 B445              * Call VTABC or VTABCZ for 40 or 80 columns.  Acc (CV)
0170 B445              * is saved in BASL.
0171 B445
0172 B445 A8           F_VTABCZ TAY                            ;restore Y
0173 B446 A5 28                 LDA   BASL                     ;and A
0174 B448 4C 9C CD              JMP   VTABCZ                   ;do VTABCZ
0175 B44B
0176 B44B              * Do BOUT, ESCFIX, BASCALCCC, and KEYIN immediately
0177 B44B              * to avoid destroying Accumulator.
0178 B44B
0179 B44B              B_KEYIN  EQU   *
0180 B44B 2C 1F C0              BIT   RD80VID                  ;80 columns?
0181 B44E 10 03                 BPL   B_KEYIN1                 ;=>no, flash the cursor
0182 B450 4C 54 C8              JMP   BIN                      ;get a keystroke
0183 B453
0184 B453              B_KEYIN1 EQU   *
0185 B453 A4 24                 LDY   CH                       ;Get cursor position
0186 B455 91 28                 STA   (BASL),Y                 ;
0187 B457 20 C9 CE              JSR   SHOWCUR                  ;Show current cursor
0188 B45A              @1       EQU   *
0189 B45A 20 FC CE              JSR   UPDATE                   ;
0190 B45D 10 FB                 BPL   @1                       ;Loop til done
0191 B45F 60                    RTS                            ;Done now exit
0192 B460
0193 B460              B_SETWNDX EQU   *
0194 B460 20 BE B3              JSR   F_SETWND                 ;set 40 column width
0195 B463 2C 1F C0              BIT   RD80VID                  ;80 columns?
0196 B466 10 02                 BPL   @1                       ;=>no, width ok
0197 B468 06 21                 ASL   WNDWDTH                  ;make it 80
0198 B46A A5 25        @1       LDA   CV
0199 B46C 8D FB 05              STA   OURCV                    ;update OURCV
0200 B46F 60                    RTS   
0201 B470
0202 B470              * HANDLE RESET FOR MONITOR:
0203 B470
0204 B470              B_RESETX EQU   *
0205 B470 A9 FF                 LDA   #$FF                     ;DESTROY MODE BYTE
0206 B472 8D FB 04              STA   MODE
0207 B475 AD 58 C0              LDA   SETAN0                   ;AN0 = TTL low
0208 B478 AD 5A C0              LDA   SETAN1                   ;AN1 = TTL low
0209 B47B AD 5D C0              LDA   CLRAN2                   ;SETUP
0210 B47E AD 5F C0              LDA   CLRAN3                   ; ANNUNCIATORS
0211 B481 20 2E 7A              JSR   SETTEXT2REG              ;Set textp2 shadowing reg first
0212 B484 A9 08                 LDA   #$08                     ;Disable super high res shadowing
0213 B486 0C 35 C0              TSB   SHADOW                   ;
0214 B489 60                    RTS   
0215 B48A
0216 B48A              * READ MEMORY LOCATION AT (PCL),Y
0217 B48A
0218 B48A              READPCY1 EQU   *
0219 B48A C8                    INY                            ;Next byte please
0220 B48B              READPCY  EQU   *
0221 B48B 08                    PHP   
0222 B48C 5A                    PHY                            ;Save 'X'/'Y' values
0223 B48D DA                    PHX                            ;
0224 B48E 20 E3 AA              JSR   PCYTOA3                  ; let A3 = PC + Y
0225 B491 20 E9 B7              JSR   READBYTE
0226 B494 FA                    PLX                            ; restore value
0227 B495 7A                    PLY                            ;
0228 B496 28                    PLP   
0229 B497              B_RDKEYXRTS EQU   *
0230 B497 60                    RTS   
0231 B498
0232 B498 A4 24        B_RDKEYX LDY   CH                       ;get cursor position
0233 B49A B1 28                 LDA   (BASL),Y                 ;and character
0234 B49C 2C 1F C0              BIT   RD80VID                  ;80 columns?
0235 B49F 30 F6                 BMI   B_RDKEYXRTS              ;=>don't display cursor
0236 B4A1 4C D2 CE              JMP   SHOWCUR2                 ;else display cursor, exit
0237 B4A4
0238 B4A4
